/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.neoforged.neoforge.common.Tags;

public class UntamedFindItem
extends Goal {
    private Starbuncle starbuncle;
    boolean itemStuck;
    int timeFinding;
    int stuckTicks;
    List<ItemEntity> destList = new ArrayList<ItemEntity>();
    ItemEntity dest;
    private final Predicate<ItemEntity> NONTAMED_TARGET_SELECTOR = itemEntity -> !itemEntity.hasPickUpDelay() && itemEntity.isAlive() && itemEntity.getItem().is(Tags.Items.NUGGETS_GOLD);

    public void stop() {
        super.stop();
        this.itemStuck = false;
        this.timeFinding = 0;
        this.destList = new ArrayList<ItemEntity>();
        this.dest = null;
        this.stuckTicks = 0;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.NONE;
    }

    public void start() {
        super.start();
        this.timeFinding = 0;
        this.itemStuck = false;
        this.stuckTicks = 0;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.HUNTING_ITEM;
    }

    public UntamedFindItem(Starbuncle starbuncle) {
        this.starbuncle = starbuncle;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public List<ItemEntity> nearbyItems() {
        return this.starbuncle.level.getEntitiesOfClass(ItemEntity.class, this.starbuncle.getAABB(), this.NONTAMED_TARGET_SELECTOR);
    }

    public boolean canContinueToUse() {
        return this.timeFinding <= 300 && !this.itemStuck && this.starbuncle.getHeldStack().isEmpty();
    }

    public boolean canUse() {
        if (!this.starbuncle.getHeldStack().isEmpty()) {
            return false;
        }
        ItemStack itemstack = this.starbuncle.getHeldStack();
        List<ItemEntity> list = this.nearbyItems();
        this.itemStuck = false;
        this.destList = new ArrayList<ItemEntity>();
        if (itemstack.isEmpty() && !list.isEmpty()) {
            this.destList.addAll(list);
        }
        if (this.destList.isEmpty()) {
            return false;
        }
        Collections.shuffle(this.destList);
        for (ItemEntity e : this.destList) {
            Path path = this.starbuncle.minecraftPathNav.createPath(BlockPos.containing((Position)e.position()), 1, 9);
            if (path == null || !path.canReach()) continue;
            this.dest = e;
            break;
        }
        if (this.dest == null) {
            this.starbuncle.setBackOff(30 + this.starbuncle.level.random.nextInt(30));
        }
        return this.dest != null && !this.nearbyItems().isEmpty();
    }

    public void tick() {
        super.tick();
        if (this.dest == null || this.dest.getItem().isEmpty() || this.dest.isRemoved()) {
            this.itemStuck = true;
            return;
        }
        ++this.timeFinding;
        this.starbuncle.minecraftPathNav.stop();
        Path path = this.starbuncle.minecraftPathNav.createPath(BlockPos.containing((Position)this.dest.position()), 1, 9);
        if (path == null || !path.canReach()) {
            ++this.stuckTicks;
            if (this.stuckTicks > 100) {
                this.itemStuck = true;
            }
            return;
        }
        ItemStack itemstack = this.starbuncle.getHeldStack();
        if (!itemstack.isEmpty()) {
            this.itemStuck = true;
            return;
        }
        this.starbuncle.getNavigation().moveTo((Entity)this.dest, 1.4);
    }

    public boolean isInterruptable() {
        return false;
    }
}

